<?php

namespace App\models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Property extends Model 
{

    protected $table = 'properties';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function protfolio()
    {
        return $this->belongsTo('App\models\Protfolio');
    }

    public function services()
    {
        return $this->hasMany('App\models\PropertyService');
    }

}